unit Main;

//      .
//          
//     ,  
//  .

//=============================================
interface
uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls;
//=============================================
type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;
//=============================================
implementation
{$R *.dfm}


//=============================================
//   TOBJ1
type TQItem = class (TObject)
  private
    fPNext  : pointer;                //    
    fSData  : array[1..3] of string;  // , , 

    //   
    function  GetDataFromOBJ(Ind : integer) : string;
    procedure SetDataToOBJ(Ind : integer; RqSData : string);
    function  GetPNextFromOBJ() : pointer;
    procedure SetPNextToOBJ(RqPNext : pointer);
  public
    //  
    property PNext : pointer read GetPNextFromOBJ write SetPNextToOBJ;
    //   
    //        fSData
    property FamilyName : string index 1 read GetDataFromOBJ write SetDataToOBJ;
    property FirstName  : string index 2 read GetDataFromOBJ write SetDataToOBJ;
    property Patronymic : string index 3 read GetDataFromOBJ write SetDataToOBJ;
    //        
    procedure PropShow(RqReport : TMemo); virtual;
end;

//=============================================
var Obj1 : TQItem;   //    
//=============================================

//    TOBJ1
//    
procedure TQItem.SetDataToOBJ(Ind : integer; RqSData : string);
begin fSData[Ind] := RqSData; end;

//      
function  TQItem.GetDataFromOBJ(Ind : integer) : string;
begin Result := fSData[Ind]; end;

//         
procedure TQItem.SetPNextToOBJ(RqPNext : pointer);
begin
  if Assigned(RqPNext)
  then begin
     try
        //  RqPNext    
        //  IS   
        if TObject(RqPNext) is TQItem
        then fPNext := RqPNext
        else begin
           fPNext := nil;
           ShowMessage ( format('%p',[RqPNext])
                       + ' -     '
                       + TObject(RqPNext).ClassName
                       + #13
                       + '      ');
        end;
     except
        fPNext := nil;
        ShowMessage ( format('%p',[RqPNext])
                     + ' -     '
                     + #13
                     + '      ');
     end;
  end
  else fPNext := nil;
end;

//      
function  TQItem.GetPNextFromOBJ() : pointer;
begin Result := fPNext; end;


//        
procedure TQItem.PropShow(RqReport : TMemo);
var P1  : pointer;        //  
    Ind : integer;
begin
  P1 := Self;
  RqReport.Lines.Add('  = ' + format('%p',[P1]));
  if Assigned(fPNext)
  then RqReport.Lines.Add(' fPNext = ' + format('%p',[fPNext]))
  else RqReport.Lines.Add(' fPNext = NIL');
  //     fSData
  for Ind := Low(fSData) to High(fSData) do RqReport.Lines.Add(fSData[Ind]);
end;

//=============================================
// 
procedure TForm1.Button1Click(Sender: TObject);
begin
   case ComboBox1.ItemIndex of
   0 : begin  //  
           Obj1.FamilyName := Edit1.Text;
       end;
   1 : begin  //  
          Obj1.FirstName := Edit1.Text;
       end;
   2 : begin  //  
           Obj1.Patronymic := Edit1.Text;
       end;
   end; // of case
   Memo1.Clear;
   Obj1.PropShow(Memo1);
end;

//    
procedure TForm1.FormCreate(Sender: TObject);
begin
   Obj1 := TQItem.Create;
   Obj1.PNext := nil;
   Obj1.FamilyName := '[]';
   Obj1.FirstName :=  '[]';
   Obj1.Patronymic := '[]';
   Memo1.Clear;
   Obj1.PropShow(Memo1);
end;

//  
procedure TForm1.FormDestroy(Sender: TObject);
begin
   Obj1.Free;
end;

end.
